package com.qxt;

import java.io.IOException;

/**
 * 企信通短信客户端完整功能演示
 */
public class App {
    public static void main(String[] args) {
        // ========== 请修改为你的实际账号信息 ==========
        String userId = "your_user_id";   //（登录后台->客户管理->我的信息）查询企业ID
        String account = "your_account";  // 短信账号
        String password = "your_password"; // 登录密码
        // ============================================

        SmsClient client = new SmsClient(userId, account, password);

        try {
            // 1. 发送短信（UTF-8）
            System.out.println(">>> 1. 发送短信（UTF-8）...");
            String sendResult = client.sendSmsUtf8("13800138000", "【智想云创】您的注册验证码：8899");
            System.out.println("发送结果: " + sendResult + "\n");

            // 2. 查询余额
            System.out.println(">>> 2. 查询余额...");
            String balance = client.queryBalance();
            System.out.println("余额结果: " + balance + "\n");
            /*
             * 返回示例: {"ReturnStatus":"Success","Message":"","Payinfo":"后付费","Overage":109346,"SendTotal":1075}
             * 字段: Overage=剩余条数, SendTotal=总发送量（预付费时为总充值点数）
             */

            // 3. 获取状态报告（最近发送的短信是否成功）
            System.out.println(">>> 3. 获取状态报告...");
            String statusReport = client.fetchStatusReport(10); // 只取10条测试
            System.out.println("状态报告: " + statusReport + "\n");
            /*
             * 返回示例: {"ReturnStatus":"Success","Message":"OK","Task":[{...}]}
             * Task[].Status: 10=成功, 20=失败
             * Task[].ErrorCode: 网关错误码
             */

            // 4. 获取上行回复（用户回复内容）
            System.out.println(">>> 4. 获取上行短信...");
            String uplink = client.fetchUplinkMessages();
            System.out.println("上行回复: " + uplink + "\n");
            /*
             * 返回示例: {"ReturnStatus":"Success","Message":"OK","Task":[{"Mobile":"136...","Content":"回复内容"}]}
             */

        } catch (IOException e) {
            System.err.println("请求失败: " + e.getMessage());
            e.printStackTrace();
        } finally {
            try {
                client.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}